"""
Draws a five-point star using repeated forward + angled turns.

The inner turning angle (here 144°) comes from the geometry of stars:
180 - (180 / points).
"""

import turtle


screen = turtle.Screen()
screen.setup(width=600, height=400)
screen.title("Python Turtle: Star Pattern")

pen = turtle.Turtle()
pen.color("gold")
pen.pensize(2)

pen.penup()
pen.goto(-50, 0)
pen.pendown()

points = 5
size = 150
angle = 180 - (180 / points)

for _ in range(points):
    pen.forward(size)
    pen.right(angle)  # 144° keeps the turtle tracing a star

screen.mainloop()

